LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
PACKAGE p_shift IS
  TYPE s_int IS RANGE 0 TO 255;
  TYPE s_array IS ARRAY(0 TO 7) OF std_logic;

  FUNCTION shiftr( a : s_array) return s_array;
  FUNCTION shiftr( a : s_int) return s_int;
END p_shift;

PACKAGE BODY p_shift IS
  FUNCTION shiftr( a : s_array) return s_array IS
    VARIABLE result : s_array;
  BEGIN
    FOR i IN a'RANGE LOOP
      IF i = a'HIGH THEN
        result(i) := '0';
      ELSE
        result(i) := a(i + 1);
      END IF;
    END LOOP;

    RETURN result;
  END shiftr;

  FUNCTION shiftr( a : s_int) return s_int IS
  BEGIN
    RETURN (a/2);
  END shiftr;
END p_shift;



USE WORK.p_shift.ALL;
ENTITY shift_example IS 
END shift_example; 

ARCHITECTURE test OF shift_example IS
  SIGNAL int_signal : s_int;
  SIGNAL array_signal : s_array;
BEGIN
  -- picks function that works with s_int type
  int_signal <= shiftr(int_signal);

  -- picks function that works with 
  -- s_array type    
  array_signal <= shiftr(array_signal);

  -- produces error because no function 
  -- will match    
  array_signal <= shiftr(int_signal); 
END test;


